% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supervisedPRIM.R
\name{predict.supervisedPRIM}
\alias{predict.supervisedPRIM}
\title{Model Predictions}
\usage{
\method{predict}{supervisedPRIM}(object, newdata, classProb = FALSE, ...)
}
\arguments{
\item{object}{A trained model of class \code{supervisedPRIM} returned by \link[supervisedPRIM]{supervisedPRIM}}

\item{newdata}{The new data on which to create predictions}

\item{classProb}{Should the function return the estimated class}

\item{...}{additional arguments (ignored)
probabilities instead of the predicted class?}
}
\description{
Perform prediction on a trained \code{supervisedPRIM} model. Output
to either predicted class or positive class probability is supported.
}
\examples{
# Train a model to determine if a flower is setosa
data(iris)
yData <- factor(ifelse(iris$Species == "setosa", "setosa", "other"), levels = c("setosa", "other"))
xData <- iris
xData$Species <- NULL
primModel <- supervisedPRIM(x = xData, y = yData)
# Predict on the original dataset
predictions <- predict(primModel, newdata = xData)
}
\author{
David Shaub
}

