% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crisk_con.R
\name{crisk_con}
\alias{crisk_con}
\title{Modify the Output for Uni-variable and Multi-variable Competing Risk Analysis (Continuous and Ordinal Only)}
\usage{
crisk_con(csurv, cevent, cvars, gnames)
}
\arguments{
\item{csurv}{the duration of follow-up time in months.}

\item{cevent}{the status indicator, which is generally 0 = alive, 1 = event, 2 = other event}

\item{cvars}{a matrix, which has the variables' values (continuous and ordinal only)}

\item{gnames}{a text vector, which are the names of the variables.}
}
\value{
a dataframe containing HRs (with 95\% Confidence Intervals) and P values
}
\description{
This function generates a table of competing risk analysis result with HR (95\% Confidence Interval),P value.
}
\examples{
Dat <- MASS::Melanoma
Dat$time <- Dat$time/30.5
X      <- cbind(Dat$age, Dat$thickness)
Gnames <- c('age', 'thickness')
output <- crisk_con(Dat$time, Dat$status, X, Gnames)

}
