% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p2excel_pre.R
\name{p2excel_pre}
\alias{p2excel_pre}
\title{Prepare to Export the Dataframe to An Excel Sheet.}
\usage{
p2excel_pre(tabname = "Default", datastable, tablename = "Default", filename)
}
\arguments{
\item{tabname}{a string with the tab's name.}

\item{datastable}{the dataframe that will be exported to Excel.}

\item{tablename}{a string containing the table label and title, which will appear as the first row}

\item{filename}{the name of the spreadsheet}
}
\value{
a spreadsheet containing all of the exported tables
}
\description{
The function saves the dataframe as a tab and prepares it for output into an excel sheet with a predetermined format.
}
\examples{
Dat <- survival::lung
results <- surv_uni_cat(Dat, "time", "status", "sex", report_index = TRUE)
wb <- openxlsx::createWorkbook()
wb <- p2excel_pre("survival_results",results,"Table 1. Overall Survival anlaysis",wb)
## Not run:
## saveWorkbook(wb, file = "os.xlsx", overwrite = TRUE)
## End(Not run)
}
