% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_multiuni.R
\name{surv_multiuni}
\alias{surv_multiuni}
\title{Modify the Output for Multiple Uni-variable Survival Analysis}
\usage{
surv_multiuni(
  dat,
  stime,
  sevent,
  catvars = NULL,
  convars = NULL,
  y1 = TRUE,
  y2 = TRUE,
  y5 = TRUE,
  medianCI = FALSE,
  report_index = FALSE
)
}
\arguments{
\item{dat}{a dat.frame.}

\item{stime}{the duration of follow-up time in months.}

\item{sevent}{the status indicator, which is generally 0 = alive, 1 = dead.}

\item{catvars}{a vector of categorical variable names.}

\item{convars}{a vector of continuous variables names.}

\item{y1}{logical value indicating whether the 1-year survival rate should be reported.}

\item{y2}{logical value indicating whether the 2-year survival rate should be reported.}

\item{y5}{logical value indicating whether the 5-year survival rate should be reported.}

\item{medianCI}{logical value indicating whether the 95 percent confidence interval of projected median survival should be reported.}

\item{report_index}{logical value indicating if to report the show AIC and C index.}
}
\value{
A tibble of survival output
}
\description{
This function generates a table with the general survival analysis results, including the number of total patients, the number of sevents, the estimated median, the 1,2,5 year rate, the HR (95 percent confidence interval), the P value, the AIC, and the C index. This function just modifies the output table's format.
}
\examples{
Dat <- survival::lung
convars <- c("age","meal.cal")
catvars <- c("sex")
surv_multiuni(Dat, "time", "status", catvars, convars, medianCI = TRUE)
}
