% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlg_input.tcltkGUI.R
\name{dlg_input.tcltkGUI}
\alias{dlg_input.tcltkGUI}
\title{A Tcl/Tk version of the \{svDialogs\} input a string or value dialog box}
\usage{
\method{dlg_input}{tcltkGUI}(message = "Enter a value", default = "", ..., gui = .GUI)
}
\arguments{
\item{message}{The message to display in the dialog box. Use \verb{\\\\n} for
line break, or provide a vector of character strings, one for each line.}

\item{default}{The default value in the text box. Single string or \code{NULL}.}

\item{...}{Not used yet.}

\item{gui}{The 'gui' object concerned by this dialog box.}
}
\value{
The string the user wrote in the dialog box.
}
\description{
Prompt for some data in a modal dialog box.
}
\examples{
library(svDialogstcltk) # Tcl/Tk dialog boxes are now used by default
\dontrun{
# Ask something...
user <- dlg_input("Who are you?", Sys.info()["user"])$res
if (!length(user)) {# The user clicked the 'cancel' button
  cat("OK, you prefer to stay anonymous!\n")
} else {
  cat("Hello", user, "\n")
}
}
}
\seealso{
\code{\link[svDialogs:dlg_input]{svDialogs::dlg_input()}}
}
\concept{Modal dialog box}
\keyword{misc}
