% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood-ratio.R
\name{lr_test}
\alias{lr_test}
\alias{print.lr_test}
\alias{summary.lr_test}
\alias{tidy.lr_test}
\alias{glance.lr_test}
\title{Likelihood-Ratio Test for Informative Survey Weights (In production)}
\usage{
lr_test(
  model,
  coef_subset = NULL,
  na.action = stats::na.omit,
  likelihood = c("pseudo", "scaled")
)

\method{print}{lr_test}(x, ...)

\method{summary}{lr_test}(object, ...)

\method{tidy}{lr_test}(x, ...)

\method{glance}{lr_test}(x, ...)
}
\arguments{
\item{model}{An object of class \code{svyglm}.}

\item{coef_subset}{Optional character vector of coefficient names to include
in the test. Defaults to all coefficients.}

\item{na.action}{Function to handle missing data before testing.}

\item{likelihood}{Character string specifying the likelihood form:
\code{"pseudo"} (default) for raw weighted likelihood,
or \code{"scaled"} to normalize weights by their mean.}

\item{x}{An object of class lr_test}

\item{...}{Additional arguments passed to methods}

\item{object}{An object of class lr_test}
}
\value{
An object of class \code{"lr_test"} containing:
  \item{statistic}{Likelihood-ratio test statistic (non-negative)}
  \item{p.value}{P-value for the test (Satterthwaite approximation)}
  \item{df}{Approximate degrees of freedom}
  \item{eigvals}{Eigenvalues of the Gamma matrix}
  \item{logLik_null}{Maximized log-likelihood under equal weights}
  \item{logLik_alt}{Maximized log-likelihood under survey weights}
  \item{method}{Name of the test performed}
  \item{call}{Function call}
}
\description{
Implements the Breidt-Herndon likelihood-ratio test for assessing whether
survey weights are informative in linear regression models. The test compares
maximized log-likelihoods under equal weights (null) and survey weights
(alternative), with an asymptotic distribution given by a weighted chi-squared
mixture.
}
\details{
The null hypothesis is that survey weights are not informative (equal weights
suffice). The alternative allows weights to affect the likelihood. The
asymptotic null distribution is a weighted chi-squared mixture; here we
approximate the p-value using a Satterthwaite moment-matching approach.
}
\references{
Breidt, F. J., & Opsomer, J. D. (1997).
  Testing for informativeness in analytic inference from complex surveys.
  *Survey Methodology*, 23(1), 1-11.

Herndon, J. (2022).
  Testing and adjusting for informative sampling in survey data.
  *Journal of Survey Statistics and Methodology*, 10(3), 455-480.
}
\seealso{
\code{\link{diff_in_coef_test}}, \code{\link{wa_test}}, \code{\link{svytestCE}}
}
\keyword{internal}
