% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_N_duration.R
\name{calc_dur_per_event}
\alias{calc_dur_per_event}
\title{Duration of Each Event}
\usage{
calc_dur_per_event(data, step2time)
}
\arguments{
\item{data}{A dataframe with an \code{event} column (added by
\code{\link{get_event_ids}}), indicating the event ID that each timestep
belongs to. Timesteps that are not part of an event should not be included
in the data.}

\item{step2time}{The sampling frequency of the dataframe (how many seconds
are between each row of the data).}
}
\value{
A dataframe with two columns, event ID and duration in seconds.
}
\description{
This function calculates the duration of each event of
 collective motion in a dataset.
}
\examples{

data <- data.frame(
set = c(rep('1', 50), rep('2', 50)),
event = c(rep(NA, 10), rep(1, 40), rep(2, 30), rep(NA, 20))
)

time_per_row <- 1 # seconds

calc_dur_per_event(data, time_per_row)

}
\seealso{
\code{\link{events_dur}}, \code{\link{get_event_ids}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
