eviatlas <- c(
  "TY  - JOUR",
  "AU  - Haddaway, Neal R.",
  "AU  - Feierman, Andrew",
  "AU  - Grainger, Matthew J.",
  "AU  - Gray, Charles T.",
  "AU  - Tanriver-Ayder, Ezgi",
  "AU  - Dhaubanjar, Sanita",
  "AU  - Westgate, Martin J.",
  "PY  - 2019",
  "DA  - 2019/06/04",
  "TI  - EviAtlas: a tool for visualising evidence synthesis databases",
  "JO  - Environmental Evidence",
  "SP  - 22",
  "VL  - 8",
  "IS  - 1",
  "SN  - 2047-2382",
  "UR  - https://doi.org/10.1186/s13750-019-0167-1",
  "DO  - 10.1186/s13750-019-0167-1",
  "ID  - Haddaway2019",
  "ER  - "
)

litsearchr <- c(
  "@article{grames2019automated,
  title={An automated approach to identifying search terms for systematic reviews using keyword co-occurrence networks},
  author={Grames, Eliza M and Stillman, Andrew N and Tingley, Morgan W and Elphick, Chris S},
  journal={Methods in Ecology and Evolution},
  volume={10},
  number={10},
  pages={1645--1654},
  year={2019},
  publisher={Wiley Online Library}
}"
)


res_synth_methods <-
  c(
    "",
    "PMID- 32336025",
    "OWN - NLM",
    "STAT- Publisher",
    "LR  - 20200426",
    "IS  - 1759-2887 (Electronic)",
    "IS  - 1759-2879 (Linking)",
    "DP  - 2020 Apr 26",
    "TI  - Risk-Of-Bias VISualization (robvis): an R package and Shiny web app for",
    "      visualizing risk-of-bias assessments.",
    "LID - 10.1002/jrsm.1411 [doi]",
    "AB  - Despite a major increase in the range and number of software offerings now",
    "      available to help researchers produce evidence syntheses, there is currently no",
    "      generic tool for producing figures to display and explore the risk-of-bias",
    "      assessments that routinely take place as part of systematic review. However,",
    "      tools such as the R programming environment and Shiny (an R package for building ",
    "      interactive web apps) have made it straightforward to produce new tools to help",
    "      in producing evidence syntheses. We present a new tool, robvis (Risk-Of-Bias",
    "      VISualization), available as an R package and web app, which facilitates rapid",
    "      production of publication-quality risk-of-bias assessment figures. We present a",
    "      timeline of the tool's development and its key functionality. This article is",
    "      protected by copyright. All rights reserved.",
    "CI  - This article is protected by copyright. All rights reserved.",
    "FAU - McGuinness, Luke A",
    "AU  - McGuinness LA",
    "AUID- ORCID: https://orcid.org/0000-0001-8730-9761",
    "AD  - MRC Integrative Epidemiology Unit at the University of Bristol, Bristol, UK.",
    "AD  - Population Health Sciences, Bristol Medical School, University of Bristol,",
    "      Bristol, UK.",
    "FAU - Higgins, Julian Pt",
    "AU  - Higgins JP",
    "AD  - MRC Integrative Epidemiology Unit at the University of Bristol, Bristol, UK.",
    "AD  - Population Health Sciences, Bristol Medical School, University of Bristol,",
    "      Bristol, UK.",
    "LA  - eng",
    "PT  - Journal Article",
    "DEP - 20200426",
    "PL  - England",
    "TA  - Res Synth Methods",
    "JT  - Research synthesis methods",
    "JID - 101543738",
    "SB  - IM",
    "OTO - NOTNLM",
    "OT  - Data visualization",
    "OT  - Evidence synthesis",
    "OT  - R",
    "OT  - Risk of bias",
    "EDAT- 2020/04/27 06:00",
    "MHDA- 2020/04/27 06:00",
    "CRDT- 2020/04/27 06:00",
    "PHST- 2020/02/27 00:00 [received]",
    "PHST- 2020/04/16 00:00 [revised]",
    "PHST- 2020/04/18 00:00 [accepted]",
    "PHST- 2020/04/27 06:00 [entrez]",
    "PHST- 2020/04/27 06:00 [pubmed]",
    "PHST- 2020/04/27 06:00 [medline]",
    "AID - 10.1002/jrsm.1411 [doi]",
    "PST - aheadofprint",
    "SO  - Res Synth Methods. 2020 Apr 26. doi: 10.1002/jrsm.1411.",
    "",
    "PMID- 31355546",
    "OWN - NLM",
    "STAT- In-Process",
    "LR  - 20200226",
    "IS  - 1759-2887 (Electronic)",
    "IS  - 1759-2879 (Linking)",
    "VI  - 10",
    "IP  - 4",
    "DP  - 2019 Dec",
    "TI  - revtools: An R package to support article screening for evidence synthesis.",
    "PG  - 606-614",
    "LID - 10.1002/jrsm.1374 [doi]",
    "AB  - The field of evidence synthesis is growing rapidly, with a corresponding increase",
    "      in the number of software tools and workflows to support the construction of",
    "      systematic reviews, systematic maps, and meta-analyses. Despite much progress,",
    "      however, a number of problems remain, including slow integration of new",
    "      statistical or methodological approaches into user-friendly software, low",
    "      prevalence of open-source software, and poor integration among distinct software ",
    "      tools. These issues hinder the utility and transparency of new methods to the",
    "      research community. Here, I present revtools, an R package to support article",
    "      screening during evidence synthesis projects. It provides tools for the import",
    "      and deduplication of bibliographic data, screening of articles by title or",
    "      abstract, and visualization of article content using topic models. The software",
    "      is entirely open-source and combines command-line scripting for experienced",
    "      programmers with custom-built user interfaces for casual users, with further",
    "      methods to support article screening to be added over time. revtools provides",
    "      free access to novel methods in an open-source environment and represents a",
    "      valuable step in expanding the capacity of R to support evidence synthesis",
    "      projects.",
    "CI  - (c) 2019 John Wiley & Sons, Ltd.",
    "FAU - Westgate, Martin J",
    "AU  - Westgate MJ",
    "AUID- ORCID: https://orcid.org/0000-0003-0854-2034",
    "AD  - Fenner School of Environment & Society, The Australian National University,",
    "      Acton, ACT, Australia.",
    "LA  - eng",
    "PT  - Journal Article",
    "DEP - 20191018",
    "PL  - England",
    "TA  - Res Synth Methods",
    "JT  - Research synthesis methods",
    "JID - 101543738",
    "SB  - IM",
    "OTO - NOTNLM",
    "OT  - data visualization",
    "OT  - meta-analysis",
    "OT  - natural language processing",
    "OT  - systematic review",
    "OT  - topic models",
    "EDAT- 2019/07/30 06:00",
    "MHDA- 2019/07/30 06:00",
    "CRDT- 2019/07/30 06:00",
    "PHST- 2019/02/25 00:00 [received]",
    "PHST- 2019/06/12 00:00 [revised]",
    "PHST- 2019/07/23 00:00 [accepted]",
    "PHST- 2019/07/30 06:00 [pubmed]",
    "PHST- 2019/07/30 06:00 [medline]",
    "PHST- 2019/07/30 06:00 [entrez]",
    "AID - 10.1002/jrsm.1374 [doi]",
    "PST - ppublish",
    "SO  - Res Synth Methods. 2019 Dec;10(4):606-614. doi: 10.1002/jrsm.1374. Epub 2019 Oct ",
    "      18."
  )

tmp1 <- tempfile(pattern = "eviatlas")
tmp2 <- tempfile(pattern = "litsearchr")
tmp3 <- tempfile(pattern = "res_synth")

writeLines(eviatlas, tmp1)
writeLines(litsearchr, tmp2)
writeLines(res_synth_methods, tmp3)

df <-
  read_refs(c(tmp1, tmp2, tmp3), return_df = TRUE, verbose = TRUE)

expect(nrow(df) == 4,
       "Number of imported example files differs from expectation")

expect(any(grep("EviAtlas", df[1,])), "First article is not expected article")

expect(any(grep("litsearchr", df[2,])), "Second article is not expected article")

expect(any(grep("robvis", df[3,])), "Third article is not expected article")
