% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewKostkaNumbers.R
\name{skewKostkaNumbers}
\alias{skewKostkaNumbers}
\title{Skew Kostka numbers}
\usage{
skewKostkaNumbers(lambda, mu, output = "vector")
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition: 
\code{lambda} is the outer partition and \code{mu} is the inner partition 
(so \code{mu} must be a subpartition of \code{lambda})}

\item{output}{the format of the output, either \code{"vector"} or 
\code{"list"}}
}
\value{
If \code{output="vector"}, the function returns a named vector. 
  This vector is made of the positive skew Kostka numbers 
  \eqn{K_{\lambda/\mu,\nu}} and its names encode the partitions \eqn{\nu}.
  If \code{ouput="list"}, the function returns a list. Each element of this 
  list is a named list with two elements: an integer partition \eqn{\nu} 
  in the field named \code{"nu"}, and the corresponding skew Kostka number 
  \eqn{K_{\lambda/\mu,\nu}} in the field named \code{"value"}. Only the 
  non-null skew Kostka numbers are provided by this list.
}
\description{
Skew Kostka numbers associated to a given skew partition.
}
\details{
The skew Kostka number \eqn{K_{\lambda/\mu,\nu}} is the number of skew 
  semistandard Young tableaux with shape \eqn{\lambda/\mu} and weight 
  \eqn{\nu}. The \emph{weight} of a Young tableau is the 
  vector whose \eqn{i}-th element is the number of occurrences of \eqn{i} 
  in this tableau.
}
\examples{
skewKostkaNumbers(c(4,2,2), c(2,2))
}
\seealso{
\code{\link{KostkaNumber}}, \code{\link{KostkaNumbersWithGivenMu}}.
}
