% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer.R
\name{buffer}
\alias{buffer}
\title{Buffers a signal vector into matrix}
\usage{
buffer(x, n, overlap, opt, nodelay = FALSE)
}
\arguments{
\item{x}{The signal vector to be buffered}

\item{n}{The desired length of data segments (rows).}

\item{overlap}{The desired amount of overlap between consecutive frames (columns) in the output matrix}

\item{opt}{The vector of samples specified to precede x[1] in an overlapping buffer}

\item{nodelay}{A logical statement to determine if the vector should be buffered with or without delay. Default is FALSE (with delay)}
}
\value{
A list with 3 elements is returned if nodelay = FALSE:
\itemize{
\item{\strong{X: }} A matrix of the buffered signal vector "vec" with "n" data segments and an overlap between consecutive frames specified by "p". The matrix starts with "opt" values if nodelay is FALSE.
\item{\strong{z: }}  The remainder of the vector which was not included in the matrix if the last column did not have a full number of rows.
\item{\strong{opt: }} The last values, length of "p", of the matrix "X".
}

If nodelay = TRUE, then a matrix of the buffered signal vector "vec" with "n" data segments and an overlap between consecutive frames specified by "overlap". The matrix starts with "opt" values if nodelay is FALSE.
}
\description{
This function is used to buffer a signal vector into a matrix of data frames. If the input for nodelay is TRUE, the the signal is buffered with no delay. If nodelay is FALSE, and specifies a vector of samples to precede x[1] in an overlapping buffer.
}
\examples{
x <- c(1:10)
n <- 3
overlap <- 2
opt <- c(2, 1)
list1 <- buffer(x, n, overlap, opt)
list2 <- buffer(x, n, overlap, nodelay = TRUE)
}
