% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust-equivocal-zone.R
\name{adjust_equivocal_zone}
\alias{adjust_equivocal_zone}
\title{Apply an equivocal zone to a binary classification model.}
\usage{
adjust_equivocal_zone(x, value = 0.1, threshold = NULL)
}
\arguments{
\item{x}{A \code{\link[=tailor]{tailor()}}.}

\item{value}{A numeric value (between zero and 1/2) or \code{\link[hardhat:tune]{hardhat::tune()}}. The
value is the size of the buffer around the threshold.}

\item{threshold}{A numeric value (between zero and one) or \code{\link[hardhat:tune]{hardhat::tune()}}.
Defaults to \code{adjust_probability_threshold(threshold)} if previously set
in \code{x}, or \code{1 / 2} if not.}
}
\value{
An updated \code{\link[=tailor]{tailor()}} containing the new operation.
}
\description{
Equivocal zones describe intervals of predicted probabilities that are deemed
too uncertain or ambiguous to be assigned a hard class. Rather than
predicting a hard class when the probability is very close to a threshold,
tailors using this adjustment predict \code{"[EQ]"}.
}
\details{
This function transforms the class prediction column \code{estimate} to have type
\code{class_pred} from \code{probably::class_pred()}. You can loosely think of this
column type as a factor, except there's a possible entry \code{"[EQ]"} that is
\emph{not} a level and will be excluded from performance metric calculations.
As a result, the output column has the same number of levels as the input,
except now has a possible entry \code{"[EQ]"} that tidymodels functions know to
exclude from further analyses.
}
\section{Data Usage}{

This adjustment doesn't require estimation and, as such, the same data that's
used to train it with \code{fit()} can be predicted on with \code{predict()}; fitting
this adjustment just collects metadata on the supplied column names and does
not risk data leakage.
}

\examples{
\dontshow{if (rlang::is_installed(c("probably", "modeldata"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
library(modeldata)

head(two_class_example)

# `predicted` gives hard class predictions based on probabilities
two_class_example |> count(predicted)

# when probabilities are within (.25, .75), consider them equivocal
tlr <-
  tailor() |>
  adjust_equivocal_zone(value = 1 / 4)

tlr

# fit by supplying column names.
tlr_fit <- fit(
  tlr,
  two_class_example,
  outcome = c(truth),
  estimate = c(predicted),
  probabilities = c(Class1, Class2)
)

tlr_fit

# adjust hard class predictions
predict(tlr_fit, two_class_example) |> count(predicted)
\dontshow{\}) # examplesIf}
}
