% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_outdated.R
\name{tar_outdated}
\alias{tar_outdated}
\title{Check which targets are outdated.}
\usage{
tar_outdated(
  names = NULL,
  shortcut = targets::tar_config_get("shortcut"),
  branches = FALSE,
  targets_only = TRUE,
  reporter = targets::tar_config_get("reporter_outdated"),
  seconds_reporter = targets::tar_config_get("seconds_reporter_outdated"),
  seconds_interval = targets::tar_config_get("seconds_interval"),
  callr_function = callr::r,
  callr_arguments = targets::tar_callr_args_default(callr_function, reporter),
  envir = parent.frame(),
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Names of the targets. \code{tar_outdated()} will check
these targets and all upstream ancestors in the dependency graph.
Set \code{names} to \code{NULL} to check/build all the targets (default).
The object supplied to \code{names} should be \code{NULL} or a
\code{tidyselect} expression like \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}
from \code{tidyselect} itself, or \code{\link[=tar_described_as]{tar_described_as()}} to select target names
based on their descriptions.}

\item{shortcut}{Logical of length 1, how to interpret the \code{names} argument.
If \code{shortcut} is \code{FALSE} (default) then the function checks
all targets upstream of \code{names} as far back as the dependency graph goes.
If \code{TRUE}, then the function only checks the targets in \code{names}
and uses stored metadata for information about upstream dependencies
as needed. \code{shortcut = TRUE} increases speed if there are a lot of
up-to-date targets, but it assumes all the dependencies
are up to date, so please use with caution.
Also, \code{shortcut = TRUE} only works if you set \code{names}.}

\item{branches}{Logical of length 1, whether to include branch names.
Including branches could get cumbersome for large pipelines.
Individual branch names are still omitted when branch-specific information
is not reliable: for example, when a pattern branches over
an outdated target.}

\item{targets_only}{Logical of length 1, whether to just restrict to targets
or to include functions and other global objects from the environment
created by running the target script file (default: \verb{_targets.R}).}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets are checked.

The default value of \code{reporter} is the value
returned by \code{tar_config_get("reporter_outdated")}.
The default of \code{tar_config_get("reporter_outdated")} is \code{"terse"}
if the calling R session is either:

\if{html}{\out{<div class="sourceCode">}}\preformatted{  1. Non-interactive (`interactive()` returns `FALSE`), or
  2. Inside a literate programming document
    (the `knitr.in.progress` global option is `TRUE`).
}\if{html}{\out{</div>}}

Otherwise, the default is \code{"balanced"}.
You can always set the reporter manually.
Choices:

\if{html}{\out{<div class="sourceCode">}}\preformatted{* `"balanced"`: a reporter that balances efficiency
  with informative detail.
  Uses a `cli` progress bar instead of printing messages
  for individual dynamic branches.
  To the right of the progress bar is a text string like
  "22.6s, 4510+, 124-" (22.6 seconds elapsed, 4510 targets
  detected as outdated so far,
  124 targets detected as up to date so far).

  For best results with the balanced reporter, you may need to
  adjust your `cli` settings. See global options `cli.num_colors`
  and `cli.dynamic` at
  <https://cli.r-lib.org/reference/cli-config.html>.
  On that page is also the `CLI_TICK_TIME` environment variable
  which controls the time delay between progress bar updates.
  If the delay is too low, then overhead from printing to the console
  may slow down the pipeline.
* `"terse"`: like `"balanced"`, except without a progress bar.
* `"silent"`: print nothing.
}\if{html}{\out{</div>}}}

\item{seconds_reporter}{Deprecated on 2025-03-31
(\code{targets} version 1.10.1.9010).}

\item{seconds_interval}{Deprecated on 2023-08-24
(targets version 1.2.2.9001).
Use \code{seconds_meta_append} and \code{seconds_meta_upload} instead.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Names of the outdated targets.
}
\description{
Checks for outdated targets in the pipeline,
targets that will be rerun automatically if you call
\code{\link[=tar_make]{tar_make()}} or similar. See \code{\link[=tar_cue]{tar_cue()}} for the rules
that decide whether a target needs to rerun.
}
\details{
Requires that you define a pipeline
with a target script file (default: \verb{_targets.R}).
(See \code{\link[=tar_script]{tar_script()}} for details.)
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(list(tar_target(x, 1 + 1)))
tar_outdated()
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_outdated()
})
}
}
\seealso{
Other inspect: 
\code{\link{tar_deps}()},
\code{\link{tar_manifest}()},
\code{\link{tar_network}()},
\code{\link{tar_sitrep}()},
\code{\link{tar_validate}()}
}
\concept{inspect}
