% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ap_classification.R
\name{classification}
\alias{classification}
\title{Retrieve the taxonomic hierarchies from local database}
\usage{
classification(x, db = "ncbi", verbose = TRUE, ...)
}
\arguments{
\item{x}{character) Vector of taxon keys for the given database}

\item{db}{character) The database to search, one of ncbi, itis,
gbif, col, or wfo}

\item{verbose}{(logical) Print verbose messages}

\item{...}{Additional arguments passed to database specific classification
functions.}
}
\value{
list of data.frames with the columns: name, rank, and id. This is
exactly equivalent to the output of \code{taxize::classification()}
}
\description{
This function is equivalent to the \code{taxize::classification()} function,
except that it uses a local database (so is much faster). The output is
identical to \code{taxize::classification()}
}
\examples{
\dontrun{
classification(c(3702, 9606))
classification(c(154395, 154357), db = "itis")
classification(c("wfo-0000291463", "wfo-7000000057"), db = "wfo")
classification(2878586, db = "gbif")
classification(c(2878586, 2704179), db = "gbif")
classification("C66T4", db = "col") # Abies Mill.
}
}
