% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{t_cornish_fisher}
\alias{t_cornish_fisher}
\title{Cornish-Fisher expansion for Welch's t-statistic}
\usage{
t_cornish_fisher(
  p,
  order = 2,
  n1,
  n2,
  mu1,
  mu2,
  sigma1,
  sigma2,
  gamma1,
  gamma2,
  tau1,
  tau2
)
}
\arguments{
\item{p}{a probability value.}

\item{order}{the order of Cornish-Fisher expansion. Valid options are 0, 1, and 2. If set to 0,
it reduces to a normal approximation and it returns the p-th percentile of standard normal distribution.}

\item{n1}{sample size for the sample from the first population.}

\item{n2}{sample size for the sample from the second population.}

\item{mu1}{mean of the first population.}

\item{mu2}{mean of the second population.}

\item{sigma1}{standard deviation of the first population.}

\item{sigma2}{standard deviation of the second population.}

\item{gamma1}{skewness of the first population.}

\item{gamma2}{skewness of the second population.}

\item{tau1}{kurtosis of the first population.}

\item{tau2}{kurtosis of the second population.}
}
\value{
Cornish-Fisher expansion value evaluated at p.
}
\description{
This function provides approximation for the quantile function of the sampling distribution
of the Welch's t-statistic using Cornish-Fisher expansion (up to second order).
}
\examples{
t_cornish_fisher(0.9, order=2,
n1=60, n2=30,
mu1=0, mu2=0,
sigma1=1, sigma2=0.5,
gamma1=1, gamma2=0,
tau1=6, tau2=0)

t_cornish_fisher(0.3, order=1,
n1=60, n2=30,
mu1=0, mu2=0,
sigma1=1, sigma2=0.5,
gamma1=1, gamma2=0,
tau1=6, tau2=0)

}
