% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.poppkmod}
\alias{predict.poppkmod}
\title{Predict method for pkmod objects}
\usage{
\method{predict}{poppkmod}(object, inf, tms, ...)
}
\arguments{
\item{object}{An object with class poppkmod.}

\item{inf}{A matrix with columns "begin","end","inf_rate" indicating when infusions should
be administered. Can be created by `inf_manual` or `inf_tci`.}

\item{tms}{Times at which to calculate predicted concentrations.}

\item{...}{List or vector of values to be passed on to predict.pkmod.}
}
\value{
Matrix of predicted concentrations associated with a poppkmod object and
and infusion schedule.
}
\description{
Predict concentrations from a pkmod object - can be a user defined function
}
\examples{
# dosing schedule
dose <- inf_manual(inf_tms = c(0,0.5,4,4.5,10), inf_rate = c(100,0,80,0,0))
# poppkmod object
data <- data.frame(ID = 1:5, AGE = seq(20,60,by=10), TBW = seq(60,80,by=5),
HGT = seq(150,190,by=10), MALE = c(TRUE,TRUE,FALSE,FALSE,FALSE))
elvd_mod <- poppkmod(data, drug = "ppf", model = "eleveld")
predict(elvd_mod, inf = dose, tms = c(1.5,2.5,3))
}
