% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fithill.R
\name{fithill}
\alias{fithill}
\title{Hill Model Fit}
\usage{
fithill(
  conc,
  resp,
  bidirectional = TRUE,
  verbose = FALSE,
  nofit = FALSE,
  errfun = "dt4"
)
}
\arguments{
\item{conc}{Vector of concentration values NOT in log units.}

\item{resp}{Vector of corresponding responses.}

\item{bidirectional}{If TRUE, model can be positive or negative; if FALSE, it
will be positive only.}

\item{verbose}{If TRUE, gives optimization and hessian inversion details.}

\item{nofit}{If nofit = TRUE, returns formatted output filled with missing values.}

\item{errfun}{Which error distribution to assume for each point, defaults to
"dt4". "dt4" is the original 4 degrees of freedom t-distribution. Another
supported distribution is "dnorm", the normal distribution.}
}
\value{
Named list containing: success, aic (Akaike Information Criteria),
  cov (success of covariance calculation), rme (root mean square error),
  modl (vector of model values at given concentrations),
  parameters values, parameter sd (standard deviation) estimates, pars
  (vector of parameter names), sds (vector of parameter sd names).
}
\description{
Function that fits to \eqn{f(x) = \frac{tp}{[(1 + (ga/x)^p )]}} and returns generic model
outputs.
}
\details{
Concentrations are converted internally to log10 units and optimized with
\eqn{f(x) = \frac{tp}{(1 + 10^{(p*(ga-x))} )}}, then ga and ga_sd are converted back to
regular units before returning.
Zero background and increasing initial absolute response are assumed.
Parameters are "tp" (top, theoretical maximal response), "ga" (gain AC50),
"p" (gain power), and error term "er".
success = 1 for a successful fit, 0 if optimization failed, and NA if
nofit = TRUE. cov = 1 for a successful hessian inversion, 0 if it fails, and NA
if nofit = TRUE. aic, rme, modl, parameters, and parameter sds are set to
NA in case of nofit or failure.
}
\examples{
fithill(c(.03,.1,.3,1,3,10,30,100), c(0,0,.1, .2, .5, 1, 1.5, 2))
}
