% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_extract_module.R
\name{data_extract_multiple_srv}
\alias{data_extract_multiple_srv}
\alias{data_extract_multiple_srv.reactive}
\alias{data_extract_multiple_srv.FilteredData}
\alias{data_extract_multiple_srv.list}
\title{Creates a named list of \code{data_extract_srv} output}
\usage{
data_extract_multiple_srv(data_extract, datasets, ...)

\method{data_extract_multiple_srv}{reactive}(data_extract, datasets, ...)

\method{data_extract_multiple_srv}{FilteredData}(data_extract, datasets, ...)

\method{data_extract_multiple_srv}{list}(
  data_extract,
  datasets,
  join_keys = NULL,
  select_validation_rule = NULL,
  filter_validation_rule = NULL,
  dataset_validation_rule = if (is.null(select_validation_rule) &&
    is.null(filter_validation_rule)) {
     NULL
 } else {
    
    shinyvalidate::sv_required("Please select a dataset")
 },
  ...
)
}
\arguments{
\item{data_extract}{(named \code{list} of \code{data_extract_spec} objects) the list \code{data_extract_spec} objects.
The names of the elements in the list need to correspond to the \code{ids} passed to \code{data_extract_ui}.

See example for details.}

\item{datasets}{(\code{FilteredData} or \code{list} of \code{reactive} or non-\code{reactive} \code{data.frame})
object containing data either in the form of \code{FilteredData} or as a list of \code{data.frame}.
When passing a list of non-reactive \code{data.frame} objects, they are converted to reactive \code{data.frame}s internally.
When passing a list of reactive or non-reactive \code{data.frame} objects, the argument \code{join_keys} is required also.}

\item{...}{An additional argument \code{join_keys} is required when \code{datasets} is a list of \code{data.frame}.
It shall contain the keys per dataset in \code{datasets}.}

\item{join_keys}{(\code{join_keys} or \code{NULL}) of join keys per dataset in \code{datasets}.}

\item{select_validation_rule}{(\code{NULL} or \code{function} or \verb{named list} of \code{function})
Should there be any \code{shinyvalidate} input validation of the select parts of the \code{data_extract_ui}.
If all \code{data_extract} require the same validation function then this can be used directly
(i.e. \code{select_validation_rule = shinyvalidate::sv_required()}).

For more fine-grained control use a list:

\code{select_validation_rule = list(extract_1 = sv_required(), extract2 = ~ if (length(.) > 2) "Error")}

If \code{NULL} then no validation will be added.

See example for more details.}

\item{filter_validation_rule}{(\code{NULL} or \code{function} or \verb{named list} of \code{function}) Same as
\code{select_validation_rule} but for the filter (values) part of the \code{data_extract_ui}.}

\item{dataset_validation_rule}{(\code{NULL} or \code{function} or \verb{named list} of \code{function}) Same as
\code{select_validation_rule} but for the choose dataset part of the \code{data_extract_ui}}
}
\value{
reactive named \code{list} containing outputs from \code{\link[=data_extract_srv]{data_extract_srv()}}.
Output list names are the same as \code{data_extract} input argument.
}
\description{
\code{data_extract_multiple_srv} loops over the list of \code{data_extract} given and
runs \code{data_extract_srv} for each one returning a list of reactive objects.
}
\examples{
library(shiny)
library(shinyvalidate)
library(shinyjs)
library(teal.widgets)

iris_select <- data_extract_spec(
  dataname = "iris",
  select = select_spec(
    label = "Select variable:",
    choices = variable_choices(iris, colnames(iris)),
    selected = "Sepal.Length",
    multiple = TRUE,
    fixed = FALSE
  )
)

iris_filter <- data_extract_spec(
  dataname = "iris",
  filter = filter_spec(
    vars = "Species",
    choices = c("setosa", "versicolor", "virginica"),
    selected = "setosa",
    multiple = TRUE
  )
)

data_list <- list(iris = reactive(iris))

ui <- bslib::page_fluid(
  useShinyjs(),
  bslib::layout_sidebar(
    verbatimTextOutput("out1"),
    sidebar = tagList(
      data_extract_ui(
        id = "x_var",
        label = "Please select an X column",
        data_extract_spec = iris_select
      ),
      data_extract_ui(
        id = "species_var",
        label = "Please select 2 Species",
        data_extract_spec = iris_filter
      )
    )
  )
)

server <- function(input, output, session) {
  selector_list <- data_extract_multiple_srv(
    list(x_var = iris_select, species_var = iris_filter),
    datasets = data_list,
    select_validation_rule = list(
      x_var = sv_required("Please select an X column")
    ),
    filter_validation_rule = list(
      species_var = compose_rules(
        sv_required("Exactly 2 Species must be chosen"),
        function(x) if (length(x) != 2) "Exactly 2 Species must be chosen"
      )
    )
  )
  iv_r <- reactive({
    iv <- InputValidator$new()
    compose_and_enable_validators(
      iv,
      selector_list,
      validator_names = NULL
    )
  })

  output$out1 <- renderPrint({
    if (iv_r()$is_valid()) {
      ans <- lapply(selector_list(), function(x) {
        cat(format_data_extract(x()), "\n\n")
      })
    } else {
      "Please fix errors in your selection"
    }
  })
}

if (interactive()) {
  shinyApp(ui, server)
}
}
