% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_data_module.R,
%   R/teal_data_module-eval_code.R, R/teal_data_module-within.R
\name{teal_data_module}
\alias{teal_data_module}
\alias{eval_code}
\alias{eval_code,teal_data_module}
\alias{\S4method{eval_code}{teal_data_module}}
\alias{within}
\alias{within.teal_data_module}
\title{Data module for \code{teal} applications}
\usage{
teal_data_module(ui, server, label = "data module", once = TRUE)

\S4method{eval_code}{teal_data_module}(object, code)

\method{within}{teal_data_module}(data, expr, ...)
}
\arguments{
\item{ui}{(\verb{function(id)})
\code{shiny} module UI function; must only take \code{id} argument}

\item{server}{(\verb{function(id)})
\code{shiny} module server function; must only take \code{id} argument;
must return reactive expression containing \code{teal_data} object}

\item{label}{(\code{character(1)}) Label of the module.}

\item{once}{(\code{logical(1)})
If \code{TRUE}, the data module will be shown only once and will disappear after successful data loading.
App user will no longer be able to interact with this module anymore.
If \code{FALSE}, the data module can be reused multiple times.
App user will be able to interact and change the data output from the module multiple times.}

\item{object}{(\code{teal_data_module})}

\item{code}{(\code{character}, \code{language} or \code{expression}) code to evaluate.
It is possible to preserve original formatting of the \code{code} by providing a \code{character} or an
\code{expression} being a result of \code{parse(keep.source = TRUE)}.}

\item{data}{(\code{teal_data_module}) object}

\item{expr}{(\code{expression}) to evaluate. Must be inline code. See \code{\link[=within]{within()}}}

\item{...}{See \code{Details}.}
}
\value{
\code{teal_data_module} returns a list of class \code{teal_data_module} containing two elements, \code{ui} and
\code{server} provided via arguments.

\code{eval_code} returns a \code{teal_data_module} object with a delayed evaluation of \code{code} when the module is run.

\code{within} returns a \code{teal_data_module} object with a delayed evaluation of \code{expr} when the module is run.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Create a \code{teal_data_module} object and evaluate code on it with history tracking.
}
\details{
\code{teal_data_module} creates a \code{shiny} module to interactively supply or modify data in a \code{teal} application.
The module allows for running any code (creation \emph{and} some modification) after the app starts or reloads.
The body of the server function will be run in the app rather than in the global environment.
This means it will be run every time the app starts, so use sparingly.

Pass this module instead of a \code{teal_data} object in a call to \code{\link[=init]{init()}}.
Note that the server function must always return a \code{teal_data} object wrapped in a reactive expression.

See vignette \code{vignette("data-as-shiny-module", package = "teal")} for more details.

\code{eval_code} evaluates given code in the environment of the \code{teal_data} object created by the \code{teal_data_module}.
The code is added to the \verb{@code} slot of the \code{teal_data}.

\code{within} is a convenience function for evaluating inline code inside the environment of a \code{teal_data_module}.
It accepts only inline expressions (both simple and compound) and allows for injecting values into \code{expr} through
the \code{...} argument: as \code{name:value} pairs are passed to \code{...}, \code{name} in \code{expr} will be replaced with \code{value.}
}
\examples{
tdm <- teal_data_module(
  ui = function(id) {
    ns <- NS(id)
    actionButton(ns("submit"), label = "Load data")
  },
  server = function(id) {
    moduleServer(id, function(input, output, session) {
      eventReactive(input$submit, {
        data <- within(
          teal_data(),
          {
            dataset1 <- iris
            dataset2 <- mtcars
          }
        )

        data
      })
    })
  }
)

eval_code(tdm, "dataset1 <- subset(dataset1, Species == 'virginica')")

within(tdm, dataset1 <- subset(dataset1, Species == "virginica"))

# use additional parameter for expression value substitution.
valid_species <- "versicolor"
within(tdm, dataset1 <- subset(dataset1, Species \%in\% species), species = valid_species)
}
\seealso{
\code{\link[teal.data:teal_data-class]{teal.data::teal_data}}, \code{\link[teal.code:qenv]{teal.code::qenv()}}
}
