% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_finder.R
\name{correlation_finder}
\alias{correlation_finder}
\title{Function to find strong correlations within environmental predictors}
\usage{
correlation_finder(
  environmental_data,
  method = "spearman",
  threshold,
  verbose = TRUE
)
}
\arguments{
\item{environmental_data}{A matrix or data.frame containing
environmental data.}

\item{method}{Method used to estimate the correlation matrix. Possible
options include "spearman" (Spearman's rank correlation),
"pearson" (Pearson's correlation),
or "kendall" (Kendall's tau correlation).}

\item{threshold}{Correlation threshold value. Variables with absolute
correlation values greater than or equal to this threshold are considered
strongly correlated.}

\item{verbose}{Logical. If \code{TRUE}, prints verbose output detailing
correlations.}
}
\value{
A list with two elements:
\itemize{
\item \code{not_correlated_vars}: A vector containing names of variables that are
not strongly correlated.
\item \code{correlation_values}: A list with correlation values for all pairs of
variables.
}
}
\description{
This function identifies variables with strong correlations based on a
specified threshold.
}
\examples{
\donttest{

library(tenm)
data("abronia")
tempora_layers_dir <- system.file("extdata/bio",package = "tenm")
abt <- tenm::sp_temporal_data(occs = abronia,
                              longitude = "decimalLongitude",
                              latitude = "decimalLatitude",
                              sp_date_var = "year",
                              occ_date_format="y",
                              layers_date_format= "y",
                              layers_by_date_dir = tempora_layers_dir,
                              layers_ext="*.tif$")
abtc <- tenm::clean_dup_by_date(abt,threshold = 10/60)
future::plan("multisession",workers=2)
abex <- tenm::ex_by_date(abtc,train_prop=0.7)
future::plan("sequential")
envdata <- abex$env_data[,-ncol(abex$env_data)]
ecors <- tenm::correlation_finder(environmental_data =envdata,
                                  method="spearman",
                                  threshold = 0.7 )
}

}
