% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_tensor.R
\name{qr2}
\alias{qr2}
\title{QR Decomposition.}
\usage{
qr2(X)
}
\arguments{
\item{X}{A matrix of dimension \eqn{n} by \eqn{p} where \eqn{n \ge p}}
}
\value{
\code{Q} An \eqn{n} by \eqn{p} matrix with orthonormal columns.

\code{R} A \eqn{p} by \eqn{p} upper-triangular matrix with non-negative
diagonal elements.
}
\description{
QR decomposition, constraining the R matrix to have non-negative diagonal
entries.
}
\details{
This function is almost a wrapper for \code{qr()}, \code{qr.R()}, and
\code{qr.Q()}, except it constrains the diagonal elements of \code{R} to be
non-negative. If \code{X} is full rank with fewer columns than rows, then
this is sufficient to gaurantee uniqueness of the QR decomposition
(Proposition 5.2 of
\href{https://books.google.com/books?id=WyvvAAAAMAAJ}{Eaton (1983)}).
}
\seealso{
\code{\link[base]{qr}}, \code{\link[base]{qr.Q}}, and
  \code{\link[base]{qr.R}} for the base methods on the obtaining the QR
  decomposition. \code{\link{lq}} for the related LQ decomposition.
}
\author{
David Gerard.
}
