% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bland_altman.R
\name{g_bland_altman}
\alias{g_bland_altman}
\alias{bland_altman}
\title{Bland-Altman plot}
\usage{
g_bland_altman(x, y, conf_level = 0.95)
}
\arguments{
\item{x}{(\code{numeric})\cr vector of numbers we want to analyze.}

\item{y}{(\code{numeric})\cr vector of numbers we want to analyze, to be compared with \code{x}.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}
}
\value{
A \code{ggplot} Bland-Altman plot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Graphing function that produces a Bland-Altman plot.
}
\examples{
x <- seq(1, 60, 5)
y <- seq(5, 50, 4)

g_bland_altman(x = x, y = y, conf_level = 0.9)

}
