% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_response_biomarkers_subgroups.R
\name{h_response_biomarkers_subgroups}
\alias{h_response_biomarkers_subgroups}
\alias{h_rsp_to_logistic_variables}
\alias{h_logistic_mult_cont_df}
\title{Helper functions for tabulating biomarker effects on binary response by subgroup}
\usage{
h_rsp_to_logistic_variables(variables, biomarker)

h_logistic_mult_cont_df(variables, data, control = control_logistic())
}
\arguments{
\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{biomarker}{(\code{string})\cr the name of the biomarker variable.}

\item{data}{(\code{data.frame})\cr the dataset containing the variables to summarize.}

\item{control}{(named \code{list})\cr controls for the response definition and the
confidence level produced by \code{\link[=control_logistic]{control_logistic()}}.}
}
\value{
\itemize{
\item \code{h_rsp_to_logistic_variables()} returns a named \code{list} of elements \code{response}, \code{arm}, \code{covariates}, and \code{strata}.
}

\itemize{
\item \code{h_logistic_mult_cont_df()} returns a \code{data.frame} containing estimates and statistics for the selected biomarkers.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper functions which are documented here separately to not confuse the user
when reading about the user-facing functions.
}
\section{Functions}{
\itemize{
\item \code{h_rsp_to_logistic_variables()}: helps with converting the "response" function variable list
to the "logistic regression" variable list. The reason is that currently there is an
inconsistency between the variable names accepted by \code{extract_rsp_subgroups()} and \code{fit_logistic()}.

\item \code{h_logistic_mult_cont_df()}: prepares estimates for number of responses, patients and
overall response rate, as well as odds ratio estimates, confidence intervals and p-values, for multiple
biomarkers in a given single data set.
\code{variables} corresponds to names of variables found in \code{data}, passed as a named list and requires elements
\code{rsp} and \code{biomarkers} (vector of continuous biomarker variables) and optionally \code{covariates}
and \code{strata}.

}}
\examples{
library(dplyr)
library(forcats)

adrs <- tern_ex_adrs
adrs_labels <- formatters::var_labels(adrs)

adrs_f <- adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  mutate(rsp = AVALC == "CR")
formatters::var_labels(adrs_f) <- c(adrs_labels, "Response")

# This is how the variable list is converted internally.
h_rsp_to_logistic_variables(
  variables = list(
    rsp = "RSP",
    covariates = c("A", "B"),
    strata = "D"
  ),
  biomarker = "AGE"
)

# For a single population, estimate separately the effects
# of two biomarkers.
df <- h_logistic_mult_cont_df(
  variables = list(
    rsp = "rsp",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX"
  ),
  data = adrs_f
)
df

# If the data set is empty, still the corresponding rows with missings are returned.
h_coxreg_mult_cont_df(
  variables = list(
    rsp = "rsp",
    biomarkers = c("BMRKR1", "AGE"),
    covariates = "SEX",
    strata = "STRATA1"
  ),
  data = adrs_f[NULL, ]
)

}
