% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{predict_emotion_with_emoji}
\alias{predict_emotion_with_emoji}
\title{Predict Emotion with Emoji Representation}
\usage{
predict_emotion_with_emoji(text, output_type = "textemoji")
}
\arguments{
\item{text}{Character string containing the text to analyze.}

\item{output_type}{Type of output to return. Must be one of:
\itemize{
  \item "emotion" - returns only the predicted emotion label
  \item "emoji" - returns only the corresponding emoji
  \item "textemoji" - returns original text appended with predicted emoji (default)
}}
}
\value{
Depending on output_type:
  \itemize{
    \item For "emotion": character string of predicted emotion
    \item For "emoji": character string of corresponding emoji
    \item For "textemoji": original text with appended emoji
  }
  The function also prints the result to console.
}
\description{
This function takes input text, preprocesses it, extracts TF-IDF features using a pre-trained model,
predicts the emotion using a trained classifier, and returns the result with optional emoji representation.
}
\examples{
\dontrun{
# This example is not run because it requires manually downloading
# a large external model (~30MB), which cannot be retrieved automatically
# and may fail in offline environments.
predict_emotion_with_emoji("I'm so happy today!")
predict_emotion_with_emoji("This makes me angry", "emoji")
predict_emotion_with_emoji("I feel scared", "emotion")
}

}
