% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_onehot.R
\name{step_sequence_onehot}
\alias{step_sequence_onehot}
\alias{tidy.step_sequence_onehot}
\title{Positional One-Hot encoding of Tokens}
\source{
\url{https://papers.nips.cc/paper/5782-character-level-convolutional-networks-for-text-classification.pdf}
}
\usage{
step_sequence_onehot(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  sequence_length = 100,
  padding = "pre",
  truncating = "pre",
  vocabulary = NULL,
  prefix = "seq1hot",
  keep_original_cols = FALSE,
  skip = FALSE,
  id = rand_id("sequence_onehot")
)
}
\arguments{
\item{recipe}{A \link[recipes:recipe]{recipes::recipe} object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables are affected by the step. See \code{\link[recipes:selections]{recipes::selections()}}
for more details.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new columns created by the original variables will be
used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the \code{terms} argument. This is \code{NULL}
until the step is trained by \code{\link[recipes:prep]{recipes::prep.recipe()}}.}

\item{sequence_length}{A numeric, number of characters to keep before
discarding. Defaults to 100.}

\item{padding}{'pre' or 'post', pad either before or after each sequence.
defaults to 'pre'.}

\item{truncating}{'pre' or 'post', remove values from sequences larger than
sequence_length either in the beginning or in the end of the sequence.
Defaults too 'pre'.}

\item{vocabulary}{A character vector, characters to be mapped to integers.
Characters not in the vocabulary will be encoded as 0. Defaults to
\code{letters}.}

\item{prefix}{A prefix for generated column names, defaults to "seq1hot".}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[recipes:bake]{recipes::bake.recipe()}}? While all operations are baked
when \code{\link[recipes:prep]{recipes::prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added
to the sequence of existing steps (if any).
}
\description{
\code{step_sequence_onehot()} creates a \emph{specification} of a recipe step that will
take a string and do one hot encoding for each character by position.
}
\details{
The string will be capped by the sequence_length argument, strings shorter
then sequence_length will be padded with empty characters. The encoding will
assign an integer to each character in the vocabulary, and will encode
accordingly. Characters not in the vocabulary will be encoded as 0.
}
\section{Tidying}{
When you \code{\link[recipes:tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{vocabulary}, \code{token}, and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{vocabulary}{integer, index}
\item{token}{character, text corresponding to the index}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(recipes)
library(modeldata)
data(tate_text)

tate_rec <- recipe(~medium, data = tate_text) \%>\%
  step_tokenize(medium) \%>\%
  step_tokenfilter(medium) \%>\%
  step_sequence_onehot(medium)

tate_obj <- tate_rec \%>\%
  prep()

bake(tate_obj, new_data = NULL)

tidy(tate_rec, number = 3)
tidy(tate_obj, number = 3)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Steps for Numeric Variables From Characters: 
\code{\link{step_dummy_hash}()},
\code{\link{step_textfeature}()}
}
\concept{Steps for Numeric Variables From Characters}
