% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemmatize.R
\name{lemmatize_words}
\alias{lemmatize_words}
\title{Lemmatize a Vector of Words}
\usage{
lemmatize_words(x, dictionary = lexicon::hash_lemmas, ...)
}
\arguments{
\item{x}{A vector of words.}

\item{dictionary}{A dictionary of base terms and lemmas to use for
replacement.  The first column should be the full word form in lower case
while the second column is the corresponding replacement lemma. The default
uses \code{\link[lexicon]{hash_lemmas}}.  This may come from
\code{\link[textstem]{make_lemma_dictionary}} as well, giving a more
targeted, smaller dictionary.  \code{\link[textstem]{make_lemma_dictionary}}
has choices in \code{engine}s to use for the lemmatization.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector of lemmatized words.
}
\description{
Lemmatize a vector of words.
}
\examples{
x <- c("the", NA, 'doggies', ',', 'well', 'they', "aren\\'t", 'Joyfully', 'running', '.')
lemmatize_words(x)
}
\seealso{
\code{\link[textstem]{lemmatize_strings}}
}
