% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_rotate}
\alias{img_rotate}
\title{Rotate}
\usage{
img_rotate(images, angles, interpolation = "NEAREST", name = NULL)
}
\arguments{
\item{images}{A tensor of shape (num_images, num_rows, num_columns, num_channels) (NHWC),
(num_rows, num_columns, num_channels) (HWC), or (num_rows, num_columns) (HW).}

\item{angles}{A scalar angle to rotate all images by, or (if images has rank 4) a vector
of length num_images, with an angle for each image in the batch.}

\item{interpolation}{Interpolation mode. Supported values: "NEAREST", "BILINEAR".}

\item{name}{The name of the op.}
}
\value{
Image(s) with the same type and shape as `images`, rotated by the given angle(s).
Empty space due to the rotation will be filled with zeros.
}
\description{
Rotate image(s) counterclockwise by the passed angle(s) in radians.
}
\section{Raises}{

TypeError: If `image` is an invalid type.
}

