% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{layer_sparsemax}
\alias{layer_sparsemax}
\title{Sparsemax activation function}
\usage{
layer_sparsemax(object, axis = -1, ...)
}
\arguments{
\item{object}{Model or layer object}

\item{axis}{Integer, axis along which the sparsemax normalization is applied.}

\item{...}{additional parameters to pass}
}
\value{
A tensor
}
\description{
Sparsemax activation function
}
\details{
The output shape is the same as the input shape. https://arxiv.org/abs/1602.02068
}
\examples{

\dontrun{
model = keras_model_sequential() \%>\%
  layer_conv_2d(filters = 10, kernel_size = c(3,3),input_shape = c(28,28,1),
                activation = activation_gelu) \%>\%
  layer_sparsemax()
}


}
