% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_tgam.R
\name{scale_color_tgam}
\alias{scale_color_tgam}
\alias{scale_colour_tgam}
\title{Color scale constructor for The Globe and Mail's colors}
\usage{
scale_color_tgam(palette = "main", discrete = TRUE, reverse = FALSE, ...)

scale_colour_tgam(palette = "main", discrete = TRUE, reverse = FALSE, ...)
}
\arguments{
\item{palette}{Character name of palette in tgam_palettes. Currently, one of 'main' or 'alternate'.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not}

\item{reverse}{Boolean indicating whether the palette should be reversed}

\item{...}{Additional arguments passed to discrete_scale() or
scale_color_gradientn(), used respectively when discrete is TRUE or FALSE}
}
\value{
A ggplot2 colour scale object, to be passed to a ggplot2 object
}
\description{
Color scale constructor for The Globe and Mail's colors
}
\examples{
library(ggplot2)
ggplot(diamonds, aes(depth, color = cut)) +
  geom_density() +
  xlim(55, 70) +
  scale_color_tgam()

}
