% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matrix_to_table}
\alias{matrix_to_table}
\title{Switch matrix to table}
\usage{
matrix_to_table(
  matrix,
  row_names = NULL,
  col_names = NULL,
  threshold = 0,
  keep_zero = TRUE
)
}
\arguments{
\item{matrix}{A matrix.}

\item{row_names}{Character vector of row names to filter by.}

\item{col_names}{Character vector of column names to filter by.}

\item{threshold}{The threshold for filtering values based on absolute values.
Defaults to \code{0}.}

\item{keep_zero}{Whether to keep zero values in the table. Defaults to \code{false}.}
}
\value{
A table with three columns: \code{row}, \code{col}, and \code{value}.
}
\description{
Switch matrix to table
}
\examples{
test_matrix <- simulate_sparse_matrix(10, 10)
colnames(test_matrix) <- paste0("c", 1:10)
rownames(test_matrix) <- paste0("r", 1:10)
table <- matrix_to_table(test_matrix)
matrix_new <- table_to_matrix(table)
test_matrix <- test_matrix[rownames(matrix_new), colnames(matrix_new)] |>
  as_matrix()
identical(test_matrix, matrix_new)

matrix_to_table(
  test_matrix,
  threshold = 2
)

matrix_to_table(
  test_matrix,
  row_names = c("r1", "r2"),
  col_names = c("c1", "c2")
)
}
\seealso{
\link{table_to_matrix}
}
