% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round-index.R
\name{floor_index}
\alias{floor_index}
\title{A simple wrapper of \code{\link[lubridate:round_date]{lubridate::floor_date()}}}
\usage{
floor_index(x, unit = "seconds")
}
\arguments{
\item{x}{a vector of date-time objects}

\item{unit}{a string, \code{Period} object or a date-time object. When a singleton string,
it specifies a time unit or a multiple of a unit to be rounded to. Valid base units
are \code{second}, \code{minute}, \code{hour}, \code{day}, \code{week}, \code{month}, \code{bimonth}, \code{quarter},
\code{season}, \code{halfyear} and \code{year}. Arbitrary unique English abbreviations as in the
\code{\link[lubridate:period]{period()}} constructor are allowed. Rounding to multiples of units (except weeks)
is supported.

When \code{unit} is a \code{Period} object, it is first converted to a string representation
which might not be in the same units as the constructor. For example \code{weeks(1)} is
converted to "7d 0H 0M 0S". Thus, always check the string representation of the
period before passing to this function.

When \code{unit} is a date-time object rounding is done to the nearest of the
elements in \code{unit}. If range of \code{unit} vector does not cover the range of
\code{x} \code{ceiling_date()} and \code{floor_date()} round to the \code{max(x)} and \code{min(x)}
for elements that fall outside of \code{range(unit)}.}
}
\description{
This is a thin wrapper around a \code{\link[lubridate:round_date]{lubridate::floor_date()}} that works
for \code{hms}, \code{yearmon}, and \code{yearqtr} classes as well.
}
\examples{

data(FB)
dplyr::mutate(FB, date2 = floor_index(date, "year"))

time_test <- create_series('00:00:00'~'12:00:00',
                           '1 minute', class = "hms")

dplyr::mutate(time_test, date2 = floor_index(date, "hour"))

}
\seealso{
\code{\link[lubridate:round_date]{lubridate::floor_date()}}
}
