% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_plot.R
\name{ild_plot}
\alias{ild_plot}
\title{ILD-specific plots}
\usage{
ild_plot(
  x,
  type = c("trajectory", "heatmap", "gaps", "missingness", "fitted", "residual_acf"),
  var = NULL,
  id_var = ".ild_id",
  time_var = c(".ild_time_num", ".ild_seq"),
  max_ids = 20L,
  seed = 42L,
  ...
)
}
\arguments{
\item{x}{An ILD tibble or a fitted [ild_lme()] model.}

\item{type}{Character. One of `"trajectory"`, `"heatmap"`, `"gaps"`,
`"missingness"` (person x time missingness), `"fitted"` (requires fitted model),
`"residual_acf"` (requires fitted model).}

\item{var}{For `trajectory` or `heatmap`, the variable to plot (optional;
if missing and only one non-.ild_* column exists, it is used).}

\item{id_var}{For trajectory, variable used for grouping (default `.ild_id`).}

\item{time_var}{For trajectory/gaps, x-axis: `.ild_time_num` or `.ild_seq`.}

\item{max_ids}{For trajectory, max number of persons to plot (sampled if
larger; default 20). Set to `Inf` to plot all.}

\item{seed}{Integer. Seed for sampling ids when `max_ids` is set (default 42).}

\item{...}{Unused.}
}
\value{
A ggplot object, or a list of plots for diagnostics.
}
\description{
Produces trajectory (spaghetti), heatmap, gaps, and (if a fitted model
is provided) fitted vs observed and residual ACF.
}
