test_that("GA works", {
  x <- segment(DataCPSim, method = "ga", model_fn_args = list(initial_prob = 0.01), maxiter = 5)
  expect_s3_class(x, "tidycpt")
  expect_s4_class(x$segmenter, "ga")
  expect_s3_class(as.ts(x), "ts")
  expect_s3_class(augment(x), "grouped_ts")
  expect_s3_class(tidy(x), "tbl_df")
  expect_s3_class(glance(x), "tbl_df")
  expect_type(changepoints(x), "integer")
  expect_type(fitness(x$segmenter), "double")
  expect_true(is_segmenter(x$segmenter))
  expect_true(is_model(x$model))

  x <- segment(DataCPSim, method = "ga", maxiter = 5)
  expect_s3_class(x, "tidycpt")
  expect_s4_class(x$segmenter, "ga")
  expect_s3_class(as.ts(x), "ts")
  expect_s3_class(augment(x), "grouped_ts")
  expect_s3_class(tidy(x), "tbl_df")
  expect_s3_class(glance(x), "tbl_df")
  expect_type(changepoints(x), "integer")
})
