% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_object_docs.R
\name{cluster_fit}
\alias{cluster_fit}
\title{Model Fit Object Information}
\description{
An object with class "cluster_fit" is a container for information about a
model that has been fit to the data.
}
\details{
The following model types are implemented in tidyclust:
\itemize{
\item K-Means in \code{\link[=k_means]{k_means()}}
\item Hierarchical (Agglomerative) Clustering in \code{\link[=hier_clust]{hier_clust()}}
}

The main elements of the object are:
\itemize{
\item \code{spec}: A \code{\link{cluster_spec}} object.
\item \code{fit}: The object produced by the fitting function.
\item \code{preproc}: This contains any data-specific information required to
process new a sample point for prediction. For example, if the underlying
model function requires arguments \code{x} and the user passed a formula to
\code{fit}, the \code{preproc} object would contain items such as the terms object
and so on. When no information is required, this is \code{NA}.
}

As discussed in the documentation for \code{\link{cluster_spec}}, the original
arguments to the specification are saved as quosures. These are evaluated for
the \code{cluster_fit} object prior to fitting. If the resulting model object
prints its call, any user-defined options are shown in the call preceded by a
tilde (see the example below). This is a result of the use of quosures in the
specification.

This class and structure is the basis for how \pkg{tidyclust} stores model
objects after seeing the data and applying a model.
}
