% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag_lead.R
\name{lead}
\alias{lead}
\alias{lag}
\title{Fast lead/lag for vectors}
\usage{
lead(x, n = 1L, fill = NA)

lag(x, n = 1L, fill = NA)
}
\arguments{
\item{x}{A vector}

\item{n}{a positive integer of length 1,
giving the number of positions to lead or lag by. Default uses 1}

\item{fill}{Value to use for padding when the window goes beyond the input length.
Default uses \code{NA}}
}
\value{
A vector
}
\description{
Analogous function for \code{lead} and \code{lag} in \pkg{dplyr} by
wrapping \pkg{data.table}'s \code{shift}.
}
\examples{
lead(1:5)
lag(1:5)
lead(1:5,2)
lead(1:5,n = 2,fill = 0)
}
\seealso{
\code{\link[dplyr]{lead}},\code{\link[data.table]{shift}}
}
