% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{gate_chr}
\alias{gate_chr}
\alias{gate_int}
\title{Label points within a scatter plot drawing a gate}
\usage{
gate_chr(
  .dim1,
  .dim2,
  .color = NULL,
  .shape = NULL,
  .size = NULL,
  opacity = 1,
  how_many_gates = 1,
  .group_by = NULL,
  gate_list = NULL,
  ...
)

gate_int(
  .dim1,
  .dim2,
  .color = NULL,
  .shape = NULL,
  .size = NULL,
  opacity = 1,
  how_many_gates = 1,
  .group_by = NULL,
  gate_list = NULL,
  ...
)
}
\arguments{
\item{.dim1}{A column symbol. The x dimension}

\item{.dim2}{A column symbol. The y dimension}

\item{.color}{A column symbol. Colour of points}

\item{.shape}{A column symbol. Shape of points}

\item{.size}{A column symbol. Size of points}

\item{opacity}{A number between 0 and 1. The opacity level of the data points}

\item{how_many_gates}{An integer. The number of gates to label}

\item{.group_by}{A column symbol. The column that is used to calculate distance (i.e., normally genes)}

\item{gate_list}{A list of gates. It is returned by gate function as attribute \"gate\". If you want to create this list yourself, each element of the list is a data frame with x and y columns. Each row is a coordinate. The order matter.}

\item{...}{Further parameters passed to the function gatepoints::fhs}
}
\value{
An character vector, with "0" for elements outside gates and "1..N" for the elements inside the N gates.

An integer vector, with 0 for elements outside gates and 1..N for the elements inside the N gates.
}
\description{
gate() takes as input a `tbl` formatted as | <DIMENSION 1> | <DIMENSION 2> | <...> | and calculates the rotated dimensional space of the feature value.
}
\details{
\lifecycle{maturing}

This function allow the user to label data points in inside one or more 2D gates. This package is based on on the package gatepoints.
}
\examples{

# Standard use - interactive

if(interactive()){

  tidygate::tidygate_data  \%>\%
    distinct(`ct 1` , `ct 2`, Dim1, Dim2) \%>\%
    mutate(gate = gate_chr( Dim1, Dim2)) 

}

library(magrittr)
library(dplyr)

# Standard use - programmatic
res_distinct =
 tidygate::tidygate_data  \%>\%
 distinct(`ct 1` , `ct 2`, Dim1, Dim2) \%>\%
 mutate(gate = gate_chr( Dim1, Dim2,gate_list = tidygate::gate_list)) 

# Grouping - programmatic
res =
 tidygate::tidygate_data  \%>\%
   mutate(gate = gate_chr( 
     Dim1, Dim2,
     .group_by = c(`ct 1` , `ct 2`), 
     gate_list = tidygate::gate_list
   ))


}
