% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/available.R
\name{available_levels}
\alias{available_levels}
\title{Get all available level data (final + provisional)}
\format{
A tibble with 6 variables:
\itemize{
\item \strong{STATION_NUMBER}: Unique 7 digit Water Survey of Canada station number
\item \strong{Date}: Observation date. Formatted as a Date class.
\item \strong{Parameter}: Parameter being measured. Value is "Level"
\item \strong{Value}: Level value. The units are metres.
\item \strong{Symbol}: Measurement/river conditions
\item \strong{Approval}: Approval status: "final" (approved) or "provisional" (subject to revision)
}
}
\usage{
available_levels(
  station_number,
  start_date = NULL,
  end_date = Sys.Date(),
  hydat_path = NULL,
  prov_terr_state_loc = NULL
)
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. If this argument is omitted, the value of \code{prov_terr_state_loc}
is returned.}

\item{start_date}{Start date for data retrieval in YYYY-MM-DD format.
Defaults to NULL (retrieves all available historical data).}

\item{end_date}{End date for data retrieval in YYYY-MM-DD format.
Defaults to current date (Sys.Date()).}

\item{hydat_path}{The path to the hydat database or NULL to use the default location
used by \link{download_hydat}. It is also possible to pass in an existing
database connection from \code{\link[=hy_src]{hy_src()}} such that the database only needs to be opened once per
user-level call.}

\item{prov_terr_state_loc}{Province, state or territory. If this argument is omitted, the value of \code{station_number}
is returned. See \code{unique(allstations$prov_terr_state_loc)}. Will also accept \code{CA} to return only Canadian stations.}
}
\value{
A tibble with class \code{available} combining final and provisional data
with an additional \code{Approval} column indicating whether each record is
"final" or "provisional". The object includes attributes for tracking data
sources and query metadata.
}
\description{
Convenience function that combines final historical data
(from HYDAT or web service) with provisional real-time data in a single call.
}
\details{
This function combines data from final and provisional data sources to provide a complete
water level record.
\subsection{Data Sources and Priority}{

\strong{Historical (Final) Data:}

The function automatically determines the best source for historical data:
\itemize{
\item \strong{\code{hydat_path} provided} (path to database): Uses local HYDAT database at that path
\item \strong{\code{hydat_path = FALSE}}: Forces use of web service (useful when HYDAT unavailable)
\item \strong{\code{hydat_path = NULL}} (default): Uses HYDAT default location, automatically falls back
to web service if HYDAT is unavailable
}

\strong{Real-time (Provisional) Data:}

Provisional data is retrieved from ECCC's real-time web service using the
\code{realtime_ws()} function. This data covers approximately the last 18 months
and is updated regularly. Since real-time data is collected at sub-daily
intervals, values are aggregated to daily means to match the daily format
of HYDAT data. For non-aggregated real-time data, use \code{realtime_ws()} directly.
}

\subsection{Data Approval Status}{

The \code{Approval} column uses ECCC's terminology
(see \url{https://wateroffice.ec.gc.ca/contactus/faq_e.html}):
\itemize{
\item \strong{"final"}: Historical data from HYDAT or web service that has been approved by ECCC.
\item \strong{"provisional"}: Real-time data from the web service representing the best
available measurements, but subject to revision and not yet approved by ECCC.
}
}
}
\examples{
\dontrun{
## Basic usage - get all available data
levels <- available_levels("08MF005")

## Multiple stations
levels <- available_levels(c("08MF005", "08NM116"))

## Get only recent data (last 2 years)
recent_levels <- available_levels(
  "08MF005",
  start_date = Sys.Date() - lubridate::years(2),
  end_date = Sys.Date()
)

## Force use of web service (when HYDAT not available)
levels_ws <- available_levels("08MF005", hydat_path = FALSE)
}

}
\seealso{
Other available functions: 
\code{\link{available_flows}()}
}
\concept{available functions}
