% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyhydat-package.R
\docType{package}
\name{tidyhydat-package}
\alias{tidyhydat}
\alias{tidyhydat-package}
\title{tidyhydat: Extract and Tidy Canadian 'Hydrometric' Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Provides functions to access historical and real-time national 'hydrometric' data from Water Survey of Canada data sources and then applies tidy data principles.
}
\references{
To download the latest version of hydat please:
\itemize{
\item use the \code{\link[=download_hydat]{download_hydat()}} function.
\item If that fails you can download directly from this link: \url{https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/}
}

For more information on tidy data please see
\itemize{
\item Wickham, Hadley. 2014. Tidy Data. The Journal of Statistical Software. 59. \doi{10.18637/jss.v059.i10}
\item tidy data vignette: \url{https://CRAN.R-project.org/package=tidyr/vignettes/tidy-data.html}
}

For more information on HYDAT and ECCC data sources
\itemize{
\item Please see this description of the \href{https://www.canada.ca/en/environment-climate-change/services/water-overview/quantity/monitoring/survey/data-products-services/national-archive-hydat.html}{database}
\item This page is landing page for technical description of \href{https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/}{HYDAT}
\item This pdf links to a document that outlines database table \href{https://collaboration.cmc.ec.gc.ca/cmc/hydrometrics/www/HYDAT_Definition_EN.pdf}{definitions}
\item This FAQ provides a helpful list of ECCC data source \href{https://wateroffice.ec.gc.ca/contactus/faq_e.html}{questions}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/tidyhydat/}
  \item \url{https://github.com/ropensci/tidyhydat/}
  \item Report bugs at \url{https://github.com/ropensci/tidyhydat/issues/}
}

}
\author{
\strong{Maintainer}: Sam Albers \email{sam.albers@gmail.com} (\href{https://orcid.org/0000-0002-9270-7884}{ORCID}) (Copyright holder 2022-2025) [copyright holder]

Other contributors:
\itemize{
  \item Province of British Columbia (Copyright holder 2017-2022) [copyright holder]
  \item Tula Foundation (Copyright holder 2025-present) [copyright holder]
  \item David Hutchinson \email{david.hutchinson@canada.ca} [contributor]
  \item Dewey Dunnington \email{dewey@fishandwhistle.net} [contributor]
  \item Ryan Whaley \email{rdgwhaley@gmail.com} [contributor]
  \item Government of Canada [data contributor]
  \item Luke Winslow (Reviewed for rOpenSci) [reviewer]
  \item Laura DeCicco (Reviewed for rOpenSci) [reviewer]
}

}
\keyword{internal}
