% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_gemini.R
\name{check_gemini_batch}
\alias{check_gemini_batch}
\title{Check the Status of a Gemini Batch Operation}
\usage{
check_gemini_batch(
  .llms = NULL,
  .batch_id = NULL,
  .timeout = 60,
  .max_tries = 3,
  .dry_run = FALSE
)
}
\arguments{
\item{.llms}{(Optional) List of LLMMessage objects with a \code{"batch_id"} attribute (as returned by \code{send_gemini_batch()}).}

\item{.batch_id}{(Optional) Character string: full batch operation name, e.g. \code{"batches/xyz123"}.
If both \code{.llms} and \code{.batch_id} are provided, \code{.batch_id} is used.}

\item{.timeout}{Integer. Request timeout in seconds. Default: 60.}

\item{.max_tries}{Integer. Maximum retry attempts. Default: 3.}

\item{.dry_run}{Logical. If TRUE, return the request object instead of making the request (for debugging). Default: FALSE.}
}
\value{
A tibble with the operation's metadata, including name, state, creation time, completion time, and done status.
}
\description{
Retrieves processing status and metadata for a Gemini batch operation.
}
\details{
You can supply either the \code{.batch_id} string (e.g. \code{"batches/xyz..."}) \strong{or}
a list of LLMMessage objects (\code{.llms}) with a \code{"batch_id"} attribute as returned by \code{send_gemini_batch()}.
}
