% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_claude.R
\name{claude_upload_file}
\alias{claude_upload_file}
\title{Upload a File to Claude API}
\usage{
claude_upload_file(
  .file_path,
  .api_url = "https://api.anthropic.com/",
  .timeout = 60,
  .max_tries = 3,
  .dry_run = FALSE
)
}
\arguments{
\item{.file_path}{The local file path of the file to upload.}

\item{.api_url}{Base URL for the Claude API (default: "https://api.anthropic.com/").}

\item{.timeout}{Request timeout in seconds (default: 60).}

\item{.max_tries}{Maximum retry attempts for requests (default: 3).}

\item{.dry_run}{Logical; if TRUE, returns the prepared request object without executing it.}
}
\value{
A tibble containing metadata about the uploaded file, including its file_id, name, and size.
}
\description{
Uploads a file to the Claude API and returns its metadata as a tibble.
}
