% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_gemini.R
\name{fetch_gemini_batch}
\alias{fetch_gemini_batch}
\title{Fetch Results for a Gemini Batch}
\usage{
fetch_gemini_batch(
  .llms,
  .batch_name = NULL,
  .timeout = 60,
  .max_tries = 3,
  .dry_run = FALSE
)
}
\arguments{
\item{.llms}{List of \code{LLMMessage} objects (as from \code{send_gemini_batch()}), must have a \code{batch_id} attribute if \code{.batch_name} is not given.}

\item{.batch_name}{(Optional) Character; batch operation name (e.g. "batches/xyz123"). If not provided, is taken from \code{attr(.llms, "batch_id")}.}

\item{.timeout}{Integer; request timeout in seconds (default: 60).}

\item{.max_tries}{Integer; maximum retry attempts (default: 3).}

\item{.dry_run}{Logical; if \code{TRUE}, returns the GET request object (default: FALSE).}
}
\value{
A list of updated LLMMessage objects with the assistant response appended to each, in the same order.
}
\description{
Retrieves the results of a completed Gemini batch and updates
the provided list of LLMMessage objects with the assistant's responses,
matching by original list order.
}
