% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_groq.R
\name{fetch_groq_batch}
\alias{fetch_groq_batch}
\title{Fetch Results for a Groq Batch}
\usage{
fetch_groq_batch(
  .llms,
  .batch_id = NULL,
  .api_url = "https://api.groq.com/",
  .dry_run = FALSE,
  .max_tries = 3,
  .timeout = 60
)
}
\arguments{
\item{.llms}{A list of \code{LLMMessage} objects that were part of the batch.}

\item{.batch_id}{Character; the unique identifier for the batch.}

\item{.api_url}{Character; the base URL for the Groq API (default: "https://api.groq.com/").}

\item{.dry_run}{Logical; if \code{TRUE}, returns the constructed request without executing it (default: \code{FALSE}).}

\item{.max_tries}{Integer; maximum number of retries if the request fails (default: \code{3}).}

\item{.timeout}{Integer; request timeout in seconds (default: \code{60}).}
}
\value{
A list of updated \code{LLMMessage} objects, each with the assistant's response added if successful.
}
\description{
This function retrieves the results of a completed Groq batch and updates
the provided list of \code{LLMMessage} objects with the responses.
}
