% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyllm_schema.R
\name{field_object}
\alias{field_object}
\title{Define a nested object field}
\usage{
field_object(.description = character(0), ..., .vector = FALSE)
}
\arguments{
\item{.description}{A character string describing the field (optional).}

\item{...}{Named fields to include in the object definition (required).}

\item{.vector}{A logical value indicating if the field is a list of objects (default: FALSE).}
}
\value{
An S7 \code{tidyllm_field} object of type "object" containing nested fields.
}
\description{
Define a nested object field
}
\examples{
# Define an address object with nested fields
address <- field_object("A mailing address",
  street = field_chr("Street name"),
  city = field_chr("City name"),
  zipcode = field_chr("Postal code")
)

# Create a vector of objects
addresses <- field_object("List of addresses", 
  street = field_chr("Street name"),
  city = field_chr("City name"),
  .vector = TRUE
)
}
