% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_gemini.R
\name{gemini_chat}
\alias{gemini_chat}
\title{Send LLMMessage to Gemini API}
\usage{
gemini_chat(
  .llm,
  .model = "gemini-2.5-flash",
  .fileid = NULL,
  .temperature = NULL,
  .max_output_tokens = NULL,
  .top_p = NULL,
  .top_k = NULL,
  .grounding_threshold = NULL,
  .presence_penalty = NULL,
  .frequency_penalty = NULL,
  .stop_sequences = NULL,
  .safety_settings = NULL,
  .json_schema = NULL,
  .tools = NULL,
  .timeout = 120,
  .dry_run = FALSE,
  .max_tries = 3,
  .verbose = FALSE,
  .stream = FALSE
)
}
\arguments{
\item{.llm}{An existing LLMMessage object or an initial text prompt.}

\item{.model}{The model identifier (default: "gemini-1.5-flash").}

\item{.fileid}{Optional vector of file IDs uploaded via \code{gemini_upload_file()} (default: NULL).}

\item{.temperature}{Controls randomness in generation (default: NULL, range: 0.0-2.0).}

\item{.max_output_tokens}{Maximum tokens in the response (default: NULL).}

\item{.top_p}{Controls nucleus sampling (default: NULL, range: 0.0-1.0).}

\item{.top_k}{Controls diversity in token selection (default: NULL, range: 0 or more).}

\item{.grounding_threshold}{A grounding threshold between 0 and 1. With lower
grounding thresholds  Gemini will use Google to search for relevant information
before answering.  (default: NULL).}

\item{.presence_penalty}{Penalizes new tokens (default: NULL, range: -2.0 to 2.0).}

\item{.frequency_penalty}{Penalizes frequent tokens (default: NULL, range: -2.0 to 2.0).}

\item{.stop_sequences}{Optional character sequences to stop generation (default: NULL, up to 5).}

\item{.safety_settings}{A list of safety settings (default: NULL).}

\item{.json_schema}{A schema to enforce an output structure}

\item{.tools}{Either a single TOOL object or a list of TOOL objects representing the available functions for tool calls.}

\item{.timeout}{When should our connection time out (default: 120 seconds).}

\item{.dry_run}{If TRUE, perform a dry run and return the request object.}

\item{.max_tries}{Maximum retries to perform request (default: 3).}

\item{.verbose}{Should additional information be shown after the API call.}

\item{.stream}{Should the response be streamed (default: FALSE).}
}
\value{
A new \code{LLMMessage} object containing the original messages plus the assistant's response.
}
\description{
Send LLMMessage to Gemini API
}
