% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_has_imputed.R
\name{gt_uses_imputed}
\alias{gt_uses_imputed}
\title{Checks if a \code{gen_tibble} uses imputed data}
\usage{
gt_uses_imputed(x)
}
\arguments{
\item{x}{a \code{gen_tibble}}
}
\value{
boolean TRUE or FALSE depending on whether the dataset is using the
imputed values
}
\description{
This function checks if a dataset uses imputed data. Note that it is possible
to have a dataset that has been imputed but it is currently not using
imputation.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Impute the gen_tibble
example_gt <- example_gt \%>\% gt_impute_simple()

# Check whether the gen_tibble uses imputed values
example_gt \%>\% gt_uses_imputed()
}
