% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_report_loci.R
\name{qc_report_loci}
\alias{qc_report_loci}
\alias{qc_report_loci.tbl_df}
\alias{qc_report_loci.grouped_df}
\title{Create a Quality Control report for loci}
\usage{
qc_report_loci(.x, ...)

\method{qc_report_loci}{tbl_df}(.x, ...)

\method{qc_report_loci}{grouped_df}(.x, ...)
}
\arguments{
\item{.x}{a \code{\link{gen_tibble}} object.}

\item{...}{currently unused}
}
\value{
either a tibble with 3 elements (maf, missingness and hwe_p). For
pseudohaploid data, a tibble with 2 elements (maf and missingness).
}
\description{
Return QC information to assess loci (MAF, missingness and HWE test). For
pseudohaploid data, HWE test is not calculated.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
example_gt <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Get a QC report for the loci
example_gt \%>\% qc_report_loci()

# Group by population to calculate HWE within populations
example_gt <- example_gt \%>\% group_by(population)
example_gt \%>\% qc_report_loci()

}
