% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postsynth.R
\name{print.postsynth}
\alias{print.postsynth}
\title{Print the postsynth object to the console with formatting}
\usage{
\method{print}{postsynth}(x, ...)
}
\arguments{
\item{x}{A \code{postsynth} object}

\item{...}{further arguments passed to or from other methods (not currently
used).}
}
\value{
Invisibly returns the input \code{postsynth} object.
}
\description{
Print the postsynth object to the console with formatting
}
\examples{

# create roadmap
rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
) 

rpart_mod_reg <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "regression")

rpart_mod_class <- parsnip::decision_tree() |>
  parsnip::set_engine(engine = "rpart") |>
  parsnip::set_mode(mode = "classification")

synth_spec1 <- synth_spec(
  default_regression_model = rpart_mod_reg,
  default_regression_sampler = sample_rpart,
  default_classification_model = rpart_mod_class,
  default_classification_sampler = sample_rpart
)

# create a presynth object
# use defaults for noise, constraints, and replicates
presynth1 <- presynth(
  roadmap = rm,
  synth_spec = synth_spec1
)

# synthesize!
set.seed(1)
postsynth1 <- synthesize(presynth = presynth1)

print(postsynth1)

}
