% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-spat-coordinates.R
\name{stat_spat_coordinates}
\alias{stat_spat_coordinates}
\title{Extract coordinates from \code{SpatVector} objects}
\usage{
stat_spat_coordinates(
  mapping = aes(),
  data = NULL,
  geom = "point",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{A \code{SpatVector} object, see \code{\link[terra:vect]{terra::vect()}}.}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.

You can also set this to one of "polygon", "line", and "point" to
override the default legend.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}}.}
}
\value{
A \CRANpkg{ggplot2} layer
}
\description{
\code{stat_spat_coordinates()} extracts the coordinates from \code{SpatVector} objects
and summarises them to one pair of coordinates (x and y) per geometry.
}
\details{
Wrapper of \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}}.

See \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}} for details.
}
\examples{
\donttest{
cyl <- terra::vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))

library(ggplot2)

ggplot(cyl) +
  stat_spat_coordinates()

ggplot(cyl) +
  geom_errorbarh(
    aes(
      geometry = geometry,
      xmin = after_stat(x) - 50000,
      xmax = after_stat(x) + 50000,
      y = after_stat(y),
      height = 10000
    ),
    stat = "sf_coordinates"
  )
}

}
\seealso{
Other \CRANpkg{ggplot2} utils:
\code{\link{autoplot.Spat}},
\code{\link{fortify.Spat}},
\code{\link{geom_spat_contour}},
\code{\link{geom_spatraster}()},
\code{\link{geom_spatraster_rgb}()},
\code{\link{ggspatvector}}
}
\concept{ggplot2.utils}
\keyword{internal}
