% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\docType{data}
\name{weather_options}
\alias{weather_options}
\title{tidyweather options}
\format{
An object of class \code{list} of length 3.
}
\usage{
weather_options
}
\description{
An options manager for configuring tidyweather parameters. This object provides
methods to get and set weather-related parameters.
}
\section{Available Options}{

\describe{
\item{extreme.frost_threshold}{Frost threshold for extreme weather events. Default: 0}
\item{require_full_year}{Whether to require a full year of data for certain calculations. Default: TRUE}
}
}

\section{Methods}{

\describe{
\item{get(key)}{Retrieve the value of an option by its key (e.g., "extreme.frost_threshold")}
\item{set(key, value)}{Set the value of an option by its key}
\item{reset()}{Reset all options to their default values}
}
}

\examples{
# Get default frost threshold
weather_options$get("extreme.frost_threshold")

# Set custom values
weather_options$set("extreme.frost_threshold" = -2)

# Reset to defaults
weather_options$reset()
}
\keyword{datasets}
