% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get.R
\name{tw_get}
\alias{tw_get}
\title{Return (most) information from a Wikidata item in a tidy format}
\usage{
tw_get(
  id,
  language = tidywikidatar::tw_get_language(),
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE,
  wait = 0,
  id_l = NULL,
  user_agent = tidywikidatar::tw_get_user_agent()
)
}
\arguments{
\item{id}{A character vector, must start with Q, e.g. "Q180099" for the
anthropologist Margaret Mead. Can also be a data frame of one row,
typically generated with \code{\link[=tw_search]{tw_search()}} or a combination of \code{\link[=tw_search]{tw_search()}}
and \code{\link[=tw_filter_first]{tw_filter_first()}}.}

\item{language}{Defaults to language set with \code{\link[=tw_set_language]{tw_set_language()}}; if not
set, "en". Use "all_available" to keep all languages. For available
language values, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE}. Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Logical, defaults to \code{FALSE}. If \code{TRUE}, it overwrites
the table in the local sqlite database. Useful if the original Wikidata
object has been updated.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}

\item{id_l}{Defaults to \code{NULL}. If given, must be an object or list such as
the one generated with \code{\link[=tw_get_item]{tw_get_item()}}. If given, and the requested
id is actually present in \code{id_l}, then no query to Wikidata servers is
made.}

\item{user_agent}{Defaults to \code{NULL}. If not given, implicitly defaults to
current package name (\code{tidywikidatar}) and version.}
}
\value{
A data.frame (a tibble) with three columns (\code{id}, \code{property}, and
\code{value}).
}
\description{
Return (most) information from a Wikidata item in a tidy format
}
\examples{

if (interactive()) {
  tw_get(
    id = c("Q180099", "Q228822"),
    language = "en"
  )
}

## using `tw_test_items` in examples in order to show output without calling
## on Wikidata servers

tw_get(
  id = c("Q180099", "Q228822"),
  language = "en",
  id_l = tw_test_items
)
}
