% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setops_match.R
\name{match_t}
\alias{match_t}
\alias{\%in_t\%}
\title{Matching Time Indices}
\usage{
match_t(x, table, nomatch = NA_integer_)

x \%in_t\% table
}
\arguments{
\item{x}{an object of \code{tind} class.}

\item{table}{an object of \code{tinterval} or \code{tind} class.}

\item{nomatch}{an integer value to be returned when no match is found.}
}
\value{
\code{match_t} and \code{\%in_t\%} return integer and logical vectors,
respectively. The length of the result equals length of \code{x}.
}
\description{
\code{match_t} and \code{\%in_t\%} allow for matching time indices
to time intervals and to other sets of time indices including cases when
\code{table} argument is of different type than \code{x} (of lower resolution).
}
\details{
\code{\%in_t\%} always returns \code{TRUE}/\code{FALSE}. \code{NA}s
in \code{x} argument are \emph{never} matched (\code{FALSE} is returned).
}
\note{
Since \code{match} and \code{\%in\%} are not implemented in \pkg{base} as
S3 generics, new functions had to be implemented.
}
\examples{
# match dates to months
(x <- as.date("2025-03-02") + 15 * (0:5))
(table <- as.month("2025-03") + -1:1)
match_t(x, table)
# match dates to time intervals representing months
(table <- (as.date("2025-03-01") \%--\% as.date("2025-03-31")) \%+m\% (-1:1))
match_t(x, table)
# are dates in March 2025?
x \%in_t\% "2025-03"
# NAs are _never_ matched
(x <- as.date("2025-03-02") + c(NA, 15 * (0:5)))
(table <- as.month("2025-03") + c(NA, -1:1))
match_t(x, table)
x \%in_t\% table

}
